function [Y,y,mu] = OFWA(X,W,n)

%
% [Y,y,mu] = OFWA(X,W,n)
%
% To compute the ordered FWA [1] for trapezoidal T1 FSs described by five parameters
% (e,f,g,h,i) shown in Fig. 1 of Readme.doc. If an T1 FS has only four parameters,
% then its height is considered as 1.
%
% [1] Feilong Liu and J. M. Mendel, "Aggregation using the fuzzy weighted 
% average, as computed using the Karnik-{M}endel algorithms," IEEE Trans. on
%  Fuzzy Systems, vol. 12, no.1, pp. 1--12, 2008.
%
% Dongrui WU (dongruiw@usc.edu), 11/16/2008
%
% X: T1 FSs for the subcriteria
% W: T1 FSs for the weights. It must have the same number of rows as X.
% n: number of alpha-cuts. The default value is 2.
%
% Y: the FWA approximated by 5 parameters.
% y and mu: y- and mu-coordinates of the OFWA.

if nargin==2 %% set default n
    n=2;
end

M=length(X);
c=zeros(1,M);
for i=1:M
    c(i)=centroidT1(X(i,:));
end
[c,index]=sort(c,'descend');
[Y,y,mu] = FWA(X(index,:),W,n);


